import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(14, 4))

# Define colors for statuses
clear_color = 'green'
not_clear_color = 'red'

# Define positions for the curbs
curb_positions = [(i, 0) for i in range(7)]

# Define car positions relative to their curbs
car_positions = {
    'car6': (0, 0.5), 'car7': (0, 1),  # Curb 0
    'car1': (1, 0.5), 'car8': (1, 1),  # Curb 1
    'car9': (2, 0.5), 'car4': (2, 1),  # Curb 2
    'car3': (3, 0.5),  # Curb 3
    'car0': (4, 0.5),  # Curb 4
    'car5': (5, 0.5),  # Curb 5
    'car2': (6, 0.5)   # Curb 6
}

# Define car statuses
car_statuses = {
    'car6': 'not clear', 'car7': 'clear',
    'car1': 'not clear', 'car8': 'clear',
    'car9': 'not clear', 'car4': 'clear',
    'car3': 'clear',
    'car0': 'clear',
    'car5': 'clear',
    'car2': 'clear'
}

# Draw curbs
for i, (x, y) in enumerate(curb_positions):
    ax.add_patch(patches.Rectangle((x, y), 1, 1, edgecolor='black', facecolor='lightgrey'))
    ax.text(x + 0.5, y + 0.1, f'curb_{i}', ha='center', va='center', fontsize=8, color='black')

# Draw cars
for car, (x, y) in car_positions.items():
    status = car_statuses[car]
    color = clear_color if status == 'clear' else not_clear_color
    ax.add_patch(patches.Circle((x + 0.5, y + 0.5), 0.2, edgecolor='black', facecolor=color))
    ax.text(x + 0.5, y + 0.5, car, ha='center', va='center', fontsize=8, color='white' if color == not_clear_color else 'black')
    ax.text(x + 0.5, y + 0.35, status, ha='center', va='center', fontsize=6, color='white' if color == not_clear_color else 'black')

# Add legend
legend_patches = [
    patches.Patch(color=clear_color, label='Clear'),
    patches.Patch(color=not_clear_color, label='Not Clear')
]
ax.legend(handles=legend_patches, loc='upper right')

# Set limits and remove axes
ax.set_xlim(-0.5, 7)
ax.set_ylim(-0.5, 2)
ax.axis('off')

# Save the figure
plt.savefig('parking/one_shot/ini_diagram_code/attempts/attempt_9.png', bbox_inches='tight')
plt.show()